
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
labels = [
    "Telephone", "Postal Mail", "Fax", "Email", "Social Media", "Instant Messaging", "Video Calling"
]
traditional_methods = [30, 45, 40, 0, 0, 0, 0]
digital_methods = [0, 0, 0, 25, 35, 50, 55]

line_y_1 = 30
line_y_2 = 40
line_x_1 = 2.5
line_x_2 = 4.5

# Labels and Plot Types
label_Traditional = "Traditional Methods"
label_Digital = "Digital Methods"
legend_title = "Communication Methods"

# Axes Limits and Labels
ylabel_value = "Efficiency Metric"
title_value = "Comparative Analysis of Communication Methods"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
x = np.arange(len(labels))  # the label locations
width = 0.7  # the width of the bars
ylim_values = [0, 60]
xlim_values = [-0.6, 7]

# Plotting
fig, ax = plt.subplots(
    figsize=(10, 5)
)  # Adjust the size to match the original image's dimensions
rects1 = ax.bar(x, traditional_methods, width, label=label_Traditional, color="#6897bb")
rects2 = ax.bar(x, digital_methods, width, label=label_Digital, color="#77dd77")

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)
ax.set_xticks(x)
ax.set_xticklabels(labels, rotation=45, ha="center")
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Adding the values on top of the bars
for rect in rects1:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )
for rect in rects2:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

# Reference lines
ax.axhline(y=line_y_1, color="red", linestyle="--")
ax.axhline(y=line_y_2, color="gray", linestyle="--")
ax.axvline(x=line_x_1, color="gray", linestyle="--")
ax.axvline(x=line_x_2, color="gray", linestyle="--")

# Hide the ticks
ax.tick_params(axis="both", which="both", length=0)

# Hide the right and top spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.legend(title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_91.pdf", bbox_inches="tight")
