
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the bar chart
regions = ["North", "South", "East", "West"]
strategy_a = [45000, 30000, 35000, 40000]
strategy_b = [35000, 25000, 30000, 38000]
strategy_c = [50000, 32000, 37000, 42000]

labels = ["Strategy A", "Strategy B", "Strategy C"]
ylabel = "Average Monthly Sales (in USD)"

y_index = [0, 10000, 20000, 30000, 40000, 50000]
y_label_ticks = ["0", "10k", "20k", "30k", "40k", "50k"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
ylim = [0, 55000]

# Set the figure size
plt.figure(figsize=(10, 5))

# Create the bar chart
bar_width = 0.2
index = np.arange(len(regions))

plt.bar(
    index - bar_width,
    strategy_a,
    width=bar_width,
    color="#81c784",
    edgecolor="black",
    hatch='/',
    label=labels[0],
)
plt.bar(
    index,
    strategy_b,
    width=bar_width,
    color="#64b5f6",
    edgecolor="black",
    hatch='\\',
    label=labels[1],
)
plt.bar(
    index + bar_width,
    strategy_c,
    width=bar_width,
    color="#e57373",
    edgecolor="black",
    hatch='|',
    label=labels[2],
)

# Add the text labels on top of the bars
for i in index:
    plt.text(
        i - bar_width, strategy_a[i] + 1000, f"{strategy_a[i]/1000:.1f}k", ha="center"
    )
    plt.text(i, strategy_b[i] + 1000, f"{strategy_b[i]/1000:.1f}k", ha="center")
    plt.text(i + bar_width, strategy_c[i] + 1000, f"{strategy_c[i]/1000:.1f}k", ha="center")

# Set the x-axis labels, y-axis label, and chart title
plt.xticks(index, regions)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.yticks(y_index, y_label_ticks)

# Add a legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Add grid lines
plt.grid(axis='y', linestyle='--', alpha=0.7)

# Hide the right and top spines
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_94.pdf", bbox_inches="tight")

