
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar chart
regions = ["Region A", "Region B", "Region C"]
solar = [5000, 7000, 6000]
wind = [3000, 5000, 4000]
hydro = [4000, 6000, 5000]

labels = ["Solar Energy", "Wind Energy", "Hydro Energy"]
ylabel = "Average Yearly Production (GWh)"
xlabel = "Regions"
title = "Average Yearly Renewable Energy Production by Region"
legend_labels = ["Solar", "Wind", "Hydro"]
annotation_text = ["5.0k", "7.0k", "6.0k", "3.0k", "5.0k", "4.0k", "4.0k", "6.0k", "5.0k"]

y_index = [0, 2000, 4000, 6000, 8000]
ylim = [0, 8000]
y_label_ticks = ["0", "2k", "4k", "6k", "8k"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 6))

# Create the bar chart
bar_width = 0.25
index = range(len(regions))

plt.bar(
    [i - bar_width for i in index],
    solar,
    width=bar_width,
    color="#FFD700",  # Solar: Yellow
    edgecolor="black",
    label=labels[0],
)
plt.bar(
    index,
    wind,
    width=bar_width,
    color="#32CD32",  # Wind: Green
    edgecolor="black",
    label=labels[1],
)
plt.bar(
    [i + bar_width for i in index],
    hydro,
    width=bar_width,
    color="#1E90FF",  # Hydro: Blue
    edgecolor="black",
    label=labels[2],
)

# Add the text labels on top of the bars
for i in range(len(regions)):
    plt.text(
        i - bar_width,
        solar[i] + 200,
        f"{solar[i]/1000:.1f}k",
        ha="center",
    )
    plt.text(
        i,
        wind[i] + 200,
        f"{wind[i]/1000:.1f}k",
        ha="center",
    )
    plt.text(
        i + bar_width,
        hydro[i] + 200,
        f"{hydro[i]/1000:.1f}k",
        ha="center",
    )

# Set the x-axis labels, y-axis label, and chart title
plt.xticks(index, regions)
plt.ylabel(ylabel)
plt.xlabel(xlabel)
plt.title(title)
plt.ylim(ylim)
plt.yticks(y_index, y_label_ticks)

# Add a legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Hide the right and top spines
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_95.pdf", bbox_inches="tight")
