
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Historical event labels
events = [
    "Reformation",
    "Industrial Revolution",
    "French Revolution",
    "World War I",
    "World War II",
    "Cold War",
    "Fall of Berlin Wall",
    "Internet Revolution",
    "Moon Landing",
    "Renaissance",
    "Magna Carta",
    "American Revolution",
    "Civil Rights Movement",
    "Women's Suffrage",
    "September 11 Attacks"
]

# Influence values
influence = [
    4.2,
    5.1,
    6.3,
    7.0,
    8.5,
    4.7,
    3.8,
    6.8,
    5.5,
    7.4,
    4.1,
    6.0,
    5.3,
    7.2,
    5.9
]

xlabel = "Influence (%)"
ylabel = "Historical Events"
title = "Influence of Significant Historical Events"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = list(range(0, 10))
xlim = [0, 9]

# Create horizontal bar chart
plt.figure(figsize=(10, 10))  # Adjust figure size for better visualization
plt.barh(events, influence, color="#b58900")

# Set x-axis limits
plt.xlim(xlim)

# Set x-axis ticks
plt.xticks(xticks)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add grid for better readability
plt.grid(True, which='both', linestyle='--', linewidth=0.5, color='grey', axis='x')

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_96.pdf", bbox_inches="tight")
