
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Emotion labels relevant to media consumption
emotions = [
    "Tension",
    "Curiosity",
    "Awe",
    "Humor",
    "Fear",
    "Love",
    "Empathy",
    "Inspiration",
    "Excitement",
    "Satisfaction",
]

# Approximate frequency values for the new dataset
frequencies = [
    3.5,
    4.2,
    5.0,
    5.5,
    6.0,
    6.2,
    6.8,
    7.0,
    7.5,
    8.0,
]

xlabel = "Frequency (%)"
ylabel = "Emotion"
title = "Viewer Emotions While Consuming Media Content"
xticks = list(range(0, 11))
xlim = [0, 9]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
colors = plt.cm.plasma(np.linspace(0, 1, len(emotions)))  # Use a nice colormap for the bars
plt.barh(emotions, frequencies, color=colors, edgecolor="gray")

# Set x-axis limits
plt.xlim(xlim)

# Set x-axis ticks
plt.xticks(xticks)

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add grid for better readability
plt.grid(axis='x', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_97.pdf", bbox_inches="tight")
