
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Philosophical concepts
philosophy_concepts = [
    "Metaphysics",
    "Epistemology",
    "Ethics",
    "Aesthetics",
    "Logic",
    "Political Philosophy",
    "Philosophy of Mind",
    "Existentialism",
    "Phenomenology",
    "Philosophy of Language",
    "Philosophy of Science",
    "Philosophy of Religion",
    "Pragmatism",
    "Structuralism",
    "Post-structuralism",
]

# Approximate frequency values (hypothetical data)
frequencies = np.random.uniform(2.0, 8.0, len(philosophy_concepts)).tolist()

xlabel = "Frequency (%)"
ylabel = "Philosophical Concepts"
title = "Prevalence of Philosophical Concepts"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
xticks = list(range(0, 9))
xlim = [0, 8.5]

# Create horizontal bar chart
plt.figure(figsize=(10, 8))  # Adjust figure size
plt.barh(philosophy_concepts, frequencies, color="#6a5acd", edgecolor="black")

# Set x-axis limits
plt.xlim(xlim)

# Set x-axis ticks
plt.xticks(xticks)

# Set labels and title
plt.xlabel(xlabel, fontsize=12, fontweight="bold")
plt.ylabel(ylabel, fontsize=12, fontweight="bold")
plt.title(title, fontsize=14, fontweight="bold")

# Improve visual aesthetics
plt.grid(True, axis='x', linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_98.pdf", bbox_inches="tight")
