
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New literary genre data
categories = [
    "fiction high",
    "fiction low",
    "fiction high",
    "fiction low",
    "non-fiction high",
    "non-fiction low",
    "non-fiction high",
    "non-fiction low",
    "mystery high",
    "mystery low",
    "mystery high",
    "mystery low",
    "fantasy high",
    "fantasy low",
    "fantasy high",
    "fantasy low",
    "historical high",
    "historical low"
]
gender = [0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1]

title = "Literary Genre Ratings"
ylabel = "Genre"
xlabel = "Reader Rating (1-10)"

# Extract the first group of characters from each category
first_chars = [category.split(" ")[0] for category in categories]

# Find all unique first characters
unique_chars = list(set(first_chars))

# Create a margin for each unique first character
margins = {char: i for i, char in enumerate(unique_chars)}

data = [np.random.uniform(low=1, high=10, size=100) for _ in range(len(categories))]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 10))
colors = ["#FF6347", "#4682B4"]  # Tomato for male, SteelBlue for female
# Plot each category with a margin
positions = []
for i, (category, datum, g) in enumerate(zip(categories, data, gender)):

    position = i + margins[category.split(" ")[0]]
    if position in positions:
        position = position + 4
    positions.append(position)
    bp = ax.boxplot(
        datum, positions=[position], vert=False, patch_artist=True, widths=0.6
    )
    for patch in bp["boxes"]:
        patch.set_facecolor(colors[g])
        patch.set_edgecolor("#555555")

# Adding horizontal grid lines
ax.yaxis.grid(True, linestyle='--', which='major', color='grey', alpha=.25)

ax.set_title(title)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)

plt.yticks(positions, labels=categories)

# Adding a vertical line for reference
ax.axvline(x=5, color="gray", linestyle="-", linewidth=1)

# Adding legend
import matplotlib.patches as mpatches
legend_handles = [mpatches.Patch(color=colors[0], label='Male'),
                  mpatches.Patch(color=colors[1], label='Female')]
ax.legend(handles=legend_handles, loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_26.pdf", bbox_inches="tight")
