
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# New domain data
categories = [
    "HR high", "HR low", "Finance high", "Finance low",
    "IT high", "IT low", "Marketing high", "Marketing low",
    "Sales high", "Sales low"
]

gender = [0, 1, 0, 1, 0, 1, 0, 1, 0, 1]

title = "Employee Satisfaction Ratings Across Departments"
ylabel = "Department"
xlabel = "Satisfaction Rating"

# Extract the first group of characters from each category
first_chars = [category.split(" ")[0] for category in categories]

# Find all unique first characters
unique_chars = list(set(first_chars))

# Create a margin for each unique first character
margins = {char: i for i, char in enumerate(unique_chars)}

data = [np.random.normal(loc=6, scale=1.5, size=100) if 'high' in category else np.random.normal(loc=3, scale=1.5, size=100) for category in categories]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 8))
colors = ["#6699CC", "#FFCC99"]  # Light Blue for 'high' satisfaction, Light Orange for 'low' satisfaction

# Plot each category with a margin
positions = []
for i, (category, datum, g) in enumerate(zip(categories, data, gender)):
    position = i + margins[category.split(" ")[0]]
    if position in positions:
        position = position + 4
    positions.append(position)
    bp = ax.boxplot(datum, positions=[position], vert=False, patch_artist=True, widths=0.6)
    for patch in bp["boxes"]:
        patch.set_facecolor(colors[g])

# Title and labels
ax.set_title(title, fontsize=16, fontweight='bold')
ax.set_ylabel(ylabel, fontsize=14)
ax.set_xlabel(xlabel, fontsize=14)

# Y-axis tick labels
plt.yticks(positions, labels=categories)

# Adding a vertical line for reference
ax.axvline(x=5, color="gray", linestyle="--", linewidth=1)

# Additional style adjustments
ax.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_28.pdf", bbox_inches="tight")
