
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Sample data for demonstration purposes
education_data = [np.random.normal(12, 1, 100), np.random.normal(10, 1, 100)]
income_data = [np.random.normal(50000, 5000, 100), np.random.normal(45000, 5000, 100)]

title_1 = "Education Levels"
title_2 = "Income Levels"
xticklabels = ["Group A", "Group B"]

# Chart Labels
xlabel = "Demographic Groups"
ylabel_1 = "Average Years of Education"
ylabel_2 = "Median Income (USD)"
legend_labels = ["Education", "Income"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(10, 8))

# Create subplots
fig, axs = plt.subplots(2, 2, figsize=(12, 10))

# Style settings
colors = ['#67a9cf', '#ef8a62']
medianprops = dict(color='black', linewidth=1.5)

# Plot the boxplots
bp1 = axs[0, 0].boxplot(
    education_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=medianprops
)
bp2 = axs[0, 1].boxplot(
    income_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=medianprops
)
bp3 = axs[1, 0].boxplot(
    education_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=medianprops
)
bp4 = axs[1, 1].boxplot(
    income_data,
    patch_artist=True,
    widths=0.5,
    showfliers=False,
    medianprops=medianprops
)

# Set the colors of the boxes
for bp in [bp1, bp2, bp3, bp4]:
    for patch, color in zip(bp['boxes'], colors):
        patch.set_facecolor(color)

# Set titles and labels
axs[0, 0].set_title(title_1)
axs[0, 0].grid(True, linestyle='--', which='both', color='grey', alpha=0.3)
axs[0, 0].set_xticklabels(xticklabels)
axs[0, 0].set_ylabel(ylabel_1)

axs[0, 1].set_title(title_2)
axs[0, 1].grid(True, linestyle='--', which='both', color='grey', alpha=0.3)
axs[0, 1].set_xticklabels(xticklabels)
axs[0, 1].set_ylabel(ylabel_2)

axs[1, 0].set_title(title_1)
axs[1, 0].grid(True, linestyle='--', which='both', color='grey', alpha=0.3)
axs[1, 0].set_xticklabels(xticklabels)

axs[1, 1].set_title(title_2)
axs[1, 1].grid(True, linestyle='--', which='both', color='grey', alpha=0.3)
axs[1, 1].set_xticklabels(xticklabels)

# ================
# Part 4: Saving Output
# ================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_29.pdf", bbox_inches="tight")
