
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated agricultural yield data
data_yield_A = np.random.normal(50, 8, 100)
data_yield_B = np.random.normal(45, 10, 100)
data_yield_C = np.random.normal(55, 7, 100)
data_yield_D = np.random.normal(60, 6, 100)

data = [data_yield_A, data_yield_B, data_yield_C, data_yield_D]

# Labels and Plot Types
legend_labels = ["Yield Crop A", "Yield Crop B", "Yield Crop C", "Yield Crop D"]

# Axes Limits and Labels
xticklabels = ["Crop A", "Crop B", "Crop C", "Crop D"]
ylabel_value = "Yield (tons/ha)"
title = "Agricultural Yield Comparison"
ylim_values = [20, 80]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(
    figsize=(10, 7)
)  # Adjusting figure size for better readability
bp = ax.boxplot(data, patch_artist=True, notch=False, showfliers=False)

# Customizing the boxplot colors
colors = ["#8FBC8F", "#DEB887", "#F4A460", "#FFD700"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Customizing the boxplot median lines
for median in bp["medians"]:
    median.set(color="black", linewidth=1.5)

legend_patches = [
    mpatches.Patch(color=color, label=label)
    for color, label in zip(colors, legend_labels)
]
ax.legend(handles=legend_patches, loc="upper right")

# Setting the x-axis labels
ax.set_xticklabels(xticklabels)

# Setting the y-axis label
ax.set_ylabel(ylabel_value)

# Setting the plot title
ax.set_title(title)

# Setting the y-axis limits
ax.set_ylim(ylim_values)

# Adding grid lines
ax.yaxis.grid(True, which="major", color="grey", alpha=0.5)

# Removing top and right spines for a cleaner look
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_34.pdf", bbox_inches="tight")
