
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Seed for reproducibility

# Sample data representing user engagement metrics across different social media platforms
data_facebook = [
    np.random.normal(60, 10, 50), # Morning
    np.random.normal(65, 10, 50), # Afternoon
    np.random.normal(50, 10, 50), # Evening
]
data_twitter = [
    np.random.normal(55, 8, 50),  # Morning
    np.random.normal(70, 8, 50),  # Afternoon
    np.random.normal(45, 8, 50),  # Evening
]
data_instagram = [
    np.random.normal(70, 12, 50),  # Morning
    np.random.normal(75, 12, 50),  # Afternoon
    np.random.normal(60, 12, 50),  # Evening
]

# Positions of the boxplots
positions_facebook = [1, 5, 9]
positions_twitter = [2, 6, 10]
positions_instagram = [3, 7, 11]
xticklabels = ["Morning", "Afternoon", "Evening"]
xticks = [2, 6, 10]
xlabel = "Time of Day"
ylabel = "Engagement Metric"
legend_labels = ["Facebook", "Twitter", "Instagram"]
ylim = [20, 110]
legendtitle = "Social Media Platform"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, ax = plt.subplots(figsize=(10, 6))

# Plotting the boxplots
bp_facebook = ax.boxplot(
    data_facebook,
    positions=positions_facebook,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#3498db"),
    medianprops=dict(color="black"),
    showfliers=False,
)
bp_twitter = ax.boxplot(
    data_twitter,
    positions=positions_twitter,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#e74c3c"),
    medianprops=dict(color="black"),
    showfliers=False,
)
bp_instagram = ax.boxplot(
    data_instagram,
    positions=positions_instagram,
    widths=1,
    patch_artist=True,
    boxprops=dict(facecolor="#2ecc71"),
    medianprops=dict(color="black"),
    showfliers=False,
)

# Customizing the axes
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.yaxis.grid(True, linestyle="--", linewidth=0.5)
ax.xaxis.grid(True, linestyle="--", linewidth=0.5)

# Adding legend
ax.legend(
    [bp_facebook["boxes"][0], bp_twitter["boxes"][0], bp_instagram["boxes"][0]],
    legend_labels,
    loc="upper left",
    title=legendtitle,
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_41.pdf", bbox_inches="tight")
