
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for sales across different regions
region1_center = np.random.randint(200, 500, 9)
region2_center = np.random.randint(400, 800, 9)
region3_center = np.random.randint(300, 700, 9)
region1_data = [
    np.random.normal(region1_center[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(20, 50), 9, replace=False))
]
region2_data = [
    np.random.normal(region2_center[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(30, 60), 9, replace=False))
]
region3_data = [
    np.random.normal(region3_center[i], std, 100)
    for (i, std) in enumerate(np.random.choice(range(25, 55), 9, replace=False))
]

# Text labels
titles = ["Region 1 Sales", "Region 2 Sales", "Region 3 Sales"]
ylabel = "Sales in Units"
xticklabels = [
    "Product A", "Product B", "Product C", "Product D", "Product E",
    "Product F", "Product G", "Product H", "Product I"
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 3, figsize=(25, 8))

# Create a new colormap with distinct colors
cmap = mcolors.LinearSegmentedColormap.from_list(
    "business_cmap", ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2", "#7f7f7f", "#bcbd22"]
)

# Get 9 colors from the colormap
colors = cmap(np.linspace(0, 1, 9))

# Region 1 Sales subplot
bplot = axs[0].boxplot(region1_data, patch_artist=True)
axs[0].set_title(titles[0])
axs[0].set_ylabel(ylabel)
axs[0].set_xticklabels(xticklabels, rotation=45)
for patch, color in zip(bplot["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.7)
for median in bplot['medians']:
    median.set(color='#000000', linewidth=2)

# Region 2 Sales subplot
bplot1 = axs[1].boxplot(region2_data, patch_artist=True)
axs[1].set_title(titles[1])
axs[1].set_xticklabels(xticklabels, rotation=45)
for patch, color in zip(bplot1["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.7)
for median in bplot1['medians']:
    median.set(color='#000000', linewidth=2)

# Region 3 Sales subplot
bplot2 = axs[2].boxplot(region3_data, patch_artist=True)
axs[2].set_title(titles[2])
axs[2].set_xticklabels(xticklabels, rotation=45)
for patch, color in zip(bplot2["boxes"], colors):
    patch.set_facecolor(color)
    patch.set_alpha(0.7)
for median in bplot2['medians']:
    median.set(color='#000000', linewidth=2)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("box_44.pdf", bbox_inches="tight")
