
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data representing sports performance scores for three different sports
data_football = [
    np.random.normal(75, 5, 20),  # Match 1 
    np.random.normal(78, 4, 20),  # Match 2
    np.random.normal(80, 3, 20)   # Match 3
]
data_basketball = [
    np.random.normal(85, 3, 20),  # Game 1
    np.random.normal(90, 2, 20),  # Game 2
    np.random.normal(88, 3, 20)   # Game 3
]
data_tennis = [
    np.random.normal(65, 4, 20),  # Tournament 1
    np.random.normal(70, 2, 20),  # Tournament 2
    np.random.normal(68, 3, 20)   # Tournament 3
]

# Combine data
data = [data_football, data_basketball, data_tennis]
xticklabels = ["Football", "Basketball", "Tennis"]
ylabel = "Performance Scores"
xlabel = "Sports"
xticks = [1, 3, 5]
ylim = [50, 100]
title = "Performance Scores in Different Sports"
legend_labels = ["Match/Game 1", "Match/Game 2", "Match/Game 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with specific size
fig, ax = plt.subplots(figsize=(7, 5))  # Adjusted size for better visibility

# Plot boxplots with different colors and hatch patterns
colors = ["#1f77b4", "#2ca02c", "#d62728"]  # Blue, Green, and Red
hatches = ["/", "\\", "o"]  # Diagonal, horizontal lines, and dots

for i, d in enumerate(data):
    bp = ax.boxplot(
        d,
        positions=np.array(range(len(d))) * 2 + (i + 1) * 0.5,
        widths=0.5,
        patch_artist=True,
    )
    for patch in bp["boxes"]:
        patch.set_facecolor(colors[i])
        patch.set_hatch(hatches[i])
        patch.set_edgecolor("black")
    for flier in bp["fliers"]:
        flier.set(
            marker="o", color="black", markerfacecolor="black", markersize=2, alpha=0.5
        )

# Customizing the plot
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_ylim(ylim)
ax.set_title(title)

# Adding legend manually
legend_elements = [
    Patch(facecolor=colors[0], hatch=hatches[0], label=legend_labels[0], edgecolor="black"),
    Patch(facecolor=colors[1], hatch=hatches[1], label=legend_labels[1], edgecolor="black"),
    Patch(facecolor=colors[2], hatch=hatches[2], label=legend_labels[2], edgecolor="black"),
]
ax.legend(handles=legend_elements, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_47.pdf", bbox_inches="tight")
