
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for demonstration purposes: Investment Returns across Strategies
data1 = [
    np.random.normal(0.08, 0.02, 20),
    np.random.normal(0.07, 0.015, 20),
    np.random.normal(0.10, 0.025, 20),
]
data2 = [
    np.random.normal(0.09, 0.03, 20),
    np.random.normal(0.06, 0.02, 20),
    np.random.normal(0.08, 0.022, 20),
]
data3 = [
    np.random.normal(0.07, 0.025, 20),
    np.random.normal(0.05, 0.018, 20),
    np.random.normal(0.06, 0.020, 20),
]

# Combine data
data = [data1, data2, data3]
xticklabels = ["Strategy A", "Strategy B", "Strategy C"]
ylabel = "Annual Return (%)"
xticks = [1, 3, 5]
ylim = [0.0, 0.15]
labels = ["Fund 1", "Fund 2", "Fund 3"]
title = "Investment Fund Performance Across Strategies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with specific size
fig, ax = plt.subplots(figsize=(6, 5))  # Slightly larger to ensure clarity

# Plot boxplots with different colors and hatch patterns
colors = ["#66c2a5", "#fc8d62", "#8da0cb"]  # Green, Orange, Blue
hatches = ["//", "\\\\", "oo"]  # Different hatches for distinction

for i, d in enumerate(data):
    bp = ax.boxplot(
        d,
        positions=np.array(range(len(d))) * 2 + (i + 1) * 0.5,
        widths=0.5,
        patch_artist=True,
    )
    for patch in bp["boxes"]:
        patch.set_facecolor(colors[i])
        patch.set_hatch(hatches[i])
        patch.set_edgecolor("black")  # Set edge color to black
    for flier in bp["fliers"]:
        flier.set(
            marker="d", color="black", markerfacecolor="black", markersize=4, alpha=0.5
        )

# Customizing the plot to match the given picture
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.set_title(title)

# Adding legend manually to match the picture
legend_elements = [
    Patch(facecolor=colors[0], hatch=hatches[0], label=labels[0], edgecolor="black"),
    Patch(facecolor=colors[1], hatch=hatches[1], label=labels[1], edgecolor="black"),
    Patch(facecolor=colors[2], hatch=hatches[2], label=labels[2], edgecolor="black"),
]
ax.legend(handles=legend_elements, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_48.pdf", bbox_inches="tight")
