
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Sample data for demonstration purposes (Quarterly Sales Growth Rates for 3 Years)
company1 = [
    np.random.normal(1.05, 0.05, 12),
    np.random.normal(1.07, 0.04, 12),
    np.random.normal(1.06, 0.03, 12),
]
company2 = [
    np.random.normal(1.02, 0.03, 12),
    np.random.normal(1.04, 0.02, 12),
    np.random.normal(1.03, 0.03, 12),
]
company3 = [
    np.random.normal(1.03, 0.04, 12),
    np.random.normal(1.05, 0.02, 12),
    np.random.normal(1.04, 0.02, 12),
]

# Combine data
data = [company1, company2, company3]
xticklabels = ["Year 1", "Year 2", "Year 3"]
ylabel = "Quarterly Sales Growth Rates"
xticks = [1, 3, 5]
ylim = [0.9, 1.2]
labels = ["Company A", "Company B", "Company C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with specific size
fig, ax = plt.subplots(figsize=(7, 5))  # Slightly wider for better readability

# Plot boxplots with different colors and hatch patterns
colors = ["#1f77b4", "#ff7f0e", "#2ca02c"]  # Blue, Orange, Green
hatches = ["//", "\\\\", "||"]  # Diagonal lines, and vertical bars

for i, d in enumerate(data):
    bp = ax.boxplot(
        d,
        positions=np.array(range(len(d))) * 2 + (i + 1) * 0.5,
        widths=0.5,
        patch_artist=True,
    )
    for patch in bp["boxes"]:
        patch.set_facecolor(colors[i])
        patch.set_hatch(hatches[i])
        patch.set_edgecolor("black")  # Set edge color to black
    for flier in bp["fliers"]:
        flier.set(
            marker="o", color="black", markerfacecolor="black", markersize=2, alpha=0.5
        )

# Customizing the plot to match professional business visuals
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)
ax.set_title("Quarterly Sales Growth Rates Over 3 Years")

# Adding legend manually to match the business theme
legend_elements = [
    Patch(facecolor=colors[0], hatch=hatches[0], label=labels[0], edgecolor="black"),
    Patch(facecolor=colors[1], hatch=hatches[1], label=labels[1], edgecolor="black"),
    Patch(facecolor=colors[2], hatch=hatches[2], label=labels[2], edgecolor="black"),
]
ax.legend(handles=legend_elements, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_49.pdf", bbox_inches="tight")

