
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for the boxplots
data1 = [
    np.random.normal(120, 5, 100),  # Group A
    np.random.normal(122, 5, 100),  # Group B
    np.random.normal(121, 5, 100),  # Group C
]
data2 = [
    np.random.normal(115, 4, 100),  # Group A
    np.random.normal(117, 4, 100),  # Group B
    np.random.normal(116, 4, 100),  # Group C
]
titles = ["Normal Condition", "After Medication"]
ylabels = ["Blood Pressure (mmHg)", "Blood Pressure (mmHg)"]
xticklabels = ["Group A", "Group B", "Group C"]
yticks = [np.arange(110, 130, 5), np.arange(110, 130, 5)]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom size
fig, axs = plt.subplots(1, 2, figsize=(10, 5))

# Define customized styles
boxprops = dict(linestyle='-', linewidth=1.5, color='blue')
medianprops = dict(linestyle='-', linewidth=2, color='green')
whiskerprops = dict(linestyle='--', linewidth=1.5, color='blue')
capprops = dict(linewidth=1.5, color='blue')

# Create the boxplots
bp1 = axs[0].boxplot(data1, boxprops=boxprops, medianprops=medianprops, whiskerprops=whiskerprops, capprops=capprops)
bp2 = axs[1].boxplot(data2, boxprops=boxprops, medianprops=medianprops, whiskerprops=whiskerprops, capprops=capprops)

# Set titles for subplots
axs[0].set_title(titles[0])
axs[1].set_title(titles[1])

# Set y-axis labels
axs[0].set_ylabel(ylabels[0])
axs[1].set_ylabel(ylabels[1])

axs[0].set_yticks(yticks[0])
axs[1].set_yticks(yticks[1])

# Set x-axis labels
axs[0].set_xticklabels(xticklabels, rotation=0)
axs[1].set_xticklabels(xticklabels, rotation=0)

axs[0].grid("both")
axs[1].grid("both")

# Adjust layout to match the reference picture's dimensions and spacing
plt.subplots_adjust(left=0.1, right=0.9, top=0.9, bottom=0.1, wspace=0.4, hspace=0.4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("box_52.pdf", bbox_inches="tight")
