
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for the boxplots
data = {
    "Running Duration": np.random.uniform(20, 60, 20),
    "Swimming Duration": np.random.uniform(25, 55, 20),
    "Cycling Duration": np.random.uniform(30, 70, 20),
    "Yoga Duration": np.random.uniform(15, 45, 20),
}
xlabel = "Duration (minutes)"
title = "Daily Sports Activity Durations"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(10, 6))

# Create the boxplots with specific colors
boxprops = dict(linestyle="-", linewidth=2, color="darkblue")
flierprops = dict(marker="o", color="red", markerfacecolor="red", markersize=6)
medianprops = dict(linestyle="-", linewidth=2, color="purple")

# Boxplot with vertical orientation
bp = ax.boxplot(
    data.values(),
    vert=False,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
)

colors = ["#FF9999", "#66B2FF", "#99FF99", "#FFCC99"]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)
    # Scatter plot for data points
    for j, key in enumerate(data.keys()):
        x = data[key]
        y = np.random.normal(j + 1, 0.02, size=len(x))
        plt.plot(x, y, "k.", alpha=0.6, color="#4e8a84")

# Set the x-axis labels with data keys
ax.set_yticklabels(data.keys(), ha="right")

# Set the y-axis label
ax.set_xlabel(xlabel)
ax.xaxis.grid(False)
ax.xaxis.grid(True)

# Set the title of the plot
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_55.pdf", bbox_inches="tight")
