
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New sample data for the boxplots (religion domain)
data1 = [52, 55, 53, 54, 56, 57, 58]  # Believers
data2 = [48, 49, 50, 51, 50.5, 49.5, 50.2]  # Non-Believers
xticklabels = ["Believers", "Non-Believers"]
ylabel = "Religious Knowledge Score"
xlabel = "Groups"
title = "Comparison of Religious Knowledge Scores by Group"
annotation_text = "Score Difference"
legendlabels = ["Believers", "Non-Believers"]
xlim = [0.5, 2.5]
ylim = [45, 60]
yticks = [45, 50, 55, 60]

# Position of horizontal lines for annotations
hlines = [57, 50]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified dimensions
fig, ax = plt.subplots(figsize=(8, 6))

# Create the boxplots with custom colors
bp1 = ax.boxplot(
    data1, positions=[1], widths=0.6, patch_artist=True,
    boxprops=dict(facecolor="#98C1D9", edgecolor="#3D5A80")
)
bp2 = ax.boxplot(
    data2, positions=[2], widths=0.6, patch_artist=True,
    boxprops=dict(facecolor="#EE6C4D", edgecolor="#293241")
)

# Set the labels for the x-axis and y-axis
ax.set_xticklabels(xticklabels, ha="center")
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

# Set the y-axis limits and ticks
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Add a title to the chart
ax.set_title(title)

# Add a custom annotation for the 1.0 score difference
ax.annotate(
    "",
    xy=(1.25, 57),
    xytext=(1.25, 50),
    arrowprops=dict(facecolor="black", arrowstyle="<->")
)

# Add the text for the score difference
ax.text(1.5, 53.5, annotation_text, horizontalalignment="center")

# Add the dashed lines for the annotations
ax.hlines(hlines[0], 1, 1.25, colors="grey", linestyles="dashed")
ax.hlines(hlines[1], 2, 1.25, colors="grey", linestyles="dashed")

# Improve the layout and save the plot
plt.tight_layout()
plt.savefig("box_56.pdf", bbox_inches="tight")
