
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Sample data for the education performance (departments)
data = [
    np.random.normal(75, 10, 100),
    np.random.normal(78, 12, 100),
    np.random.normal(80, 15, 100),
    np.random.normal(83, 9, 100),
    np.random.normal(77, 11, 100),
]

# Department names for the x-axis
categories = [
    "Mathematics",
    "Physics",
    "Chemistry",
    "Biology",
    "Computer Science",
]

# Axes Limits and Labels
xticks_values = range(1, len(categories) + 1)
ylim_values = [40, 120]
yticks_values = range(40, 121, 10)
yticks_label = [str(i) for i in yticks_values]
ylabel_value = "Scores"

xlabel_value = "Departments"
title_value = "Student Performance Across Departments"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 8))  # Increased size for better readability

# Create the boxplot with optimized style
boxprops = dict(linestyle='-', linewidth=3, color='blue')
medianprops = dict(color='red', linewidth=2)
whiskerprops = dict(linestyle='--', linewidth=2, color='purple')
capprops = dict(color='green', linewidth=2)
flierprops = dict(marker='o', color='green', alpha=0.5)

plt.boxplot(data, notch=True, boxprops=boxprops, medianprops=medianprops,
            whiskerprops=whiskerprops, capprops=capprops, flierprops=flierprops)

# Set the x-axis labels
plt.xticks(xticks_values, categories, fontsize=12)
plt.ylim(ylim_values)
plt.yticks(yticks_values, yticks_label, fontsize=12)

# Set the x-axis and y-axis labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title_value, fontsize=16)

# Add grid for better readability
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_61.pdf", bbox_inches="tight")
