
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# New sample data for psychology domain
# Stress level data (mean, std deviation)
data = [
    np.random.normal(5, 1.5, 100),  # Control group
    np.random.normal(3.5, 1, 100),  # Therapy group
    np.random.normal(4, 1.2, 100),  # Medication group
    np.random.normal(2.5, 0.8, 100),# Exercise group
    np.random.normal(3, 0.9, 100)   # Meditation group
]

labels = ["Control", "Therapy", "Medication", "Exercise", "Meditation"]
ylabel = "Stress Level"
xlabel = "Intervention"
title = "Stress Levels Across Different Interventions"
ylim = [0, 10]
yticks = np.arange(0, 11, 1)

# Colors for the box plot, using a calm and soothing palette
box_colors = ["#8FAADC", "#AED581", "#FFCDD2", "#FFF59D", "#CE93D8"]


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size as per the new dimensions
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(color="black"),
    medianprops=dict(color="black"),
    whiskerprops=dict(color="black", linestyle="-"),
    capprops=dict(color="black", linestyle="-"),
)

# Coloring each box
for patch, color in zip(bp["boxes"], box_colors):
    patch.set_facecolor(color)

# Set outliers styles
for flier in bp["fliers"]:
    flier.set(marker='o', color='black', alpha=0.5)

# Set the y-axis range and tick labels
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Set the y-axis label, x-axis label, and title
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')

# Adjust the tick label size
ax.tick_params(axis="both", which="major", labelsize=10)
plt.xticks(rotation=0)

# Grid styling
ax.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("box_63.pdf", bbox_inches="tight")
