
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data representing attendance rates at weekly services for different religious groups
data = [
    np.random.normal(0.65, 0.05, 100),  # Group A
    np.random.normal(0.70, 0.04, 100),  # Group B
    np.random.normal(0.60, 0.06, 100),  # Group C
    np.random.normal(0.75, 0.03, 100),  # Group D
    np.random.normal(0.68, 0.04, 100)   # Group E
]

labels = ["Group A", "Group B", "Group C", "Group D", "Group E"]
ylabel = "Attendance Rate"
xlabel = "Religious Groups"
title = "Weekly Service Attendance Rates"
ylim = [0.4, 0.9]
yticks = np.arange(0.45, 0.86, 0.05)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(
    figsize=(8, 6)
)
color_scheme = ["#d4a373", "#8cb369", "#fc6f03", "#f4a259", "#f2bc94"]


bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(color="black"),
    medianprops=dict(color="red"),
    whiskerprops=dict(color="black", linestyle="--"),
    capprops=dict(color="black", linestyle="--")
)

# Color the boxes
for patch, color in zip(bp['boxes'], color_scheme):
    patch.set_facecolor(color)

# Remove outliers
for flier in bp["fliers"]:
    flier.set(marker="", color="black")

# Set the y-axis range and tick labels
ax.set_ylim(ylim)
ax.set_yticks(yticks)

# Set the axis labels and title
ax.set_ylabel(ylabel, fontsize=12)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Set the tick label size
ax.tick_params(axis="both", which="major", labelsize=10)
plt.xticks(rotation=45)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("box_64.pdf", bbox_inches="tight")
