
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for sports domain: Goal Scoring Accuracy and Pass Completion Rate
goal_scoring_accuracy = [
    np.random.normal(0.75, 0.05, 100),
    np.random.normal(0.65, 0.06, 100),
    np.random.normal(0.70, 0.04, 100),
]
pass_completion_rate = [
    np.random.normal(85, 4, 100),
    np.random.normal(80, 5, 100),
    np.random.normal(82, 3, 100),
]

# Labels and titles for the sports data
titles = ["Goal Scoring Accuracy", "Pass Completion Rate"]
xticklabels = ["Player A", "Player B", "Player C"]
ylabels = ["Accuracy (%)", "Completion Rate (%)"]
yticks = [np.arange(0.5, 0.9, 0.1), np.arange(70, 91, 5)]
ylims = [[0.4, 0.9], [70, 90]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots with specified figure size
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))
medianprops = dict(linestyle="-", linewidth=1.5, color="darkblue")
# Left subplot - Goal Scoring Accuracy
bplot1 = ax1.boxplot(
    goal_scoring_accuracy,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="darkblue", markerfacecolor="darkblue", markersize=6),
)
ax1.set_title(titles[0])
ax1.set_xticklabels(xticklabels)
ax1.set_ylabel(ylabels[0])
ax1.set_yticks(yticks[0])
ax1.set_ylim(ylims[0])
ax1.set_facecolor("#f0f0f5")
ax1.yaxis.grid(True, color="white")

# Add median value annotations
for i, line in enumerate(bplot1["medians"]):
    x, y = line.get_xydata()[1]
    ax1.text(x-0.3, y + 0.01, f"{y:.2f}", horizontalalignment="center", color="darkblue")

# Right subplot - Pass Completion Rate
bplot2 = ax2.boxplot(
    pass_completion_rate,
    patch_artist=True,
    showfliers=True,
    widths=0.6,
    medianprops=medianprops,
    flierprops=dict(marker="o", color="darkblue", markerfacecolor="darkblue", markersize=6),
)
ax2.set_title(titles[1])
ax2.set_xticklabels(xticklabels)
ax2.set_ylabel(ylabels[1])
ax2.set_yticks(yticks[1])
ax2.set_ylim(ylims[1])
ax2.set_facecolor("#f0f0f5")
ax2.yaxis.grid(True, color="white")

# Add median value annotations
for i, line in enumerate(bplot2["medians"]):
    x, y = line.get_xydata()[1]
    ax2.text(x-0.3, y + 0.3, f"{y:.2f}", horizontalalignment="center", color="darkblue")

# Set colors for boxplots
colors = ["#ff9999", "#66b3ff", "#99ff99"]
for bplot in (bplot1, bplot2):
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_66.pdf", bbox_inches="tight")
