
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Random seed for reproducibility
np.random.seed(42)

# New data for the law domain
categories = ["Strategy A", "Strategy B", "Strategy C", "Strategy D", "Strategy E"]
case_durations = [np.random.normal(6 + i, 1.5, 100) for i in range(5)]
xlabel = "Legal Strategy"
ylabel = "Duration (months)"
threshold = 8

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 6))

# Boxplot with custom colors and styles
medianprops = dict(linestyle="-", linewidth=2, color="black")
box = ax.boxplot(case_durations, patch_artist=True, medianprops=medianprops)
colors = ["#4e79a7", "#f28e2b", "#e15759", "#76b7b2", "#59a14f"]
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

# Add threshold line
ax.axhline(threshold, color="#d62728", linestyle="--", linewidth=1.5, label="Threshold")

# Set x-axis labels
ax.set_xticklabels(categories, fontsize=12)

# Set y-axis label and title
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title("Case Duration Across Different Legal Strategies", fontsize=16, fontweight='bold')

# Add legend for the threshold line
ax.legend(loc="upper right", frameon=False, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_69.pdf", bbox_inches="tight")
