
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)  # Setting a different seed for new data

# Sample data for "Average Travel Time" (in hours)
data = {
    "Average Travel Time": np.random.rand(6, 6) * 2 + 1,  # Adjusting the range to be [1, 3] hours
}

labels = [
    "Car",
    "Bus",
    "Bicycle",
    "Walking",
    "Train",
    "Airplane",
]
xlim = [1, 3]

# Chart text label parameters
xlabel = "Travel Time (hours)"
ylabel = "Mode of Transport"
title = "Comparison of Average Travel Times Across Modes of Transport"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6), constrained_layout=True)
# Color scheme reflecting transport modes
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

bplot = ax.boxplot(
    data["Average Travel Time"],
    vert=False,
    patch_artist=True,
    showcaps=False,
    showfliers=False,
    whiskerprops=dict(color="black", linestyle="--", linewidth=1.5),
    medianprops={"color": "yellow", "linewidth": 2},
    boxprops=dict(linestyle="-", linewidth=1.5),
)

# Apply colors to box plots
for patch, color in zip(bplot["boxes"], colors):
    patch.set_facecolor(color)

# Title and labels
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)

# Y-tick labels
ax.set_yticklabels(labels, fontsize=10)

# Set x-axis limits
ax.set_xlim(xlim)

# Hide unnecessary spines
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)

# Grid settings
ax.xaxis.grid(True, linestyle='--', alpha=0.7)
ax.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_73.pdf", bbox_inches="tight")
