
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Simulated psychological test scores for 10 different runs
data = [np.random.normal(70, 10, 100) for _ in range(10)]
xticklabels = [f"Test {i+1}" for i in range(10)]
xlabel = "Psychological Test Runs"
ylabel = "Test Scores"
title = "Distribution of Test Scores Across Different Runs"
suptitle = "Psychological Assessment Results"
min_annotation = "Min Value"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(10, 6))

# Customizing boxplot appearance
boxprops = dict(linestyle="-.", linewidth=1.5, color="green", facecolor="lightgreen")
medianprops = dict(linestyle="-", linewidth=1.5, color="purple")
meanprops = dict(marker="D", markerfacecolor="yellow", markersize=7)

bp = ax.boxplot(
    data,
    patch_artist=True,
    showmeans=True,
    meanprops=meanprops,
    showfliers=False,
    boxprops=boxprops,
    medianprops=medianprops,
)

# Modify additional box properties
for patch in bp['boxes']:
    patch.set(edgecolor="darkgreen")

# Adding x-axis labels with a slant for better readability
ax.set_xticklabels(xticklabels, rotation=45, fontsize=10)

# Setting axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14, fontweight='bold')
fig.suptitle(suptitle, fontsize=16, fontweight='bold')

# Add markers and annotations for minimum values
for i, line in enumerate(bp["whiskers"][::2]):
    mid_val = line.get_ydata()[1]
    ax.plot(i + 1, mid_val, marker="o", color="red")
    ax.text(i + 1, mid_val, f'{min_annotation}', ha='center', fontsize=8, color='red')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.96])
plt.savefig("box_74.pdf", bbox_inches="tight")
