
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Simulate financial data: daily closing prices for 10 different stocks over 100 days
data = [np.random.normal(100, 15, 100) for _ in range(10)]
xticklabels = [f"Stock {i+1}" for i in range(10)]
ylabel = "Daily Closing Price ($)"
title = "Stock Price Distribution Over 100 Days"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(figsize=(10, 6))

boxprops = dict(linestyle="-", linewidth=1.5, color="green")
medianprops = dict(linestyle="-", linewidth=2, color="darkgreen")
meanprops = dict(marker="D", markeredgecolor="black", markerfacecolor="yellow")
whiskerprops = dict(linestyle="--", linewidth=1.5, color="darkgrey")
capprops = dict(linewidth=1.5, color="darkgrey")

bp = ax.boxplot(
    data,
    patch_artist=True,
    showmeans=True,
    meanprops=meanprops,
    showfliers=False,
    boxprops=boxprops,
    medianprops=medianprops,
    whiskerprops=whiskerprops,
    capprops=capprops,
)

for patch in bp["boxes"]:
    patch.set(facecolor="lightgreen")

# Set the x-axis labels
ax.set_xticklabels(xticklabels, rotation=45, ha='right')

# Set the y-axis label
ax.set_ylabel(ylabel)

# Set the title
ax.set_title(title)

# Add markers for minimum values
for i, line in enumerate(bp["whiskers"][::2]):
    min_val = line.get_ydata()[1]  # Get the y value of the minimum whisker
    ax.plot(i + 1, min_val, marker="*", color="red", markersize=10)  # Add marker

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_76.pdf", bbox_inches="tight")
