
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data: Agriculture - Irrigation Method Performance
methods = [
    "Drip Irrigation",
    "Sprinkler",
    "Surface",
    "Subsurface",
    "Blended",
    "Micro",
    "Traditional",
    "Flood",
    "Rain-fed",
    "Manual",
][::-1]
performance = [
    np.random.uniform(50, 100, 10) for _ in methods * 2
]
performance = [(perf - np.min(perf)) / (np.max(perf) - np.min(perf)) for perf in performance]

# Text Labels
xlabels = ["Field A", "Field B"]
ylimits = [[0, 11], [0, 11]]
xlimits = [[-0.05, 1.05], [-0.05, 1.05]]
yticks = [range(1, len(methods) + 1), range(1, len(methods) + 1)]

# Chart Titles and Labels
xlabel1 = "Irrigation Efficiency (Field A)"
xlabel2 = "Irrigation Efficiency (Field B)"
title = "Irrigation Method Performance Comparison"

# Colors for the plot
box_colors = [
    "#8c564b",
    "#e377c2",
    "#7f7f7f",
    "#bcbd22",
    "#17becf",
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd",
][::-1]
background_colors = ["#c7eae5", "#f6e8c3", "#fddbc7", "#e5f5e0"][::-1]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Figure and Axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6), sharey=True)
medianprops = dict(linestyle="-", linewidth=2, color="black")

# Subplot 1: Field A
bplot1 = ax1.boxplot(
    performance[:10], vert=False, medianprops=medianprops, patch_artist=True
)
ax1.set_ylim(ylimits[0])
ax1.set_yticks(yticks[0])
ax1.set_yticklabels(methods)
ax1.set_xlim(xlimits[0])
ax1.set_xlabel(xlabel1)
ax1.set_facecolor("#f7f7f7")
ax1.xaxis.grid(True)
ax1.set_axisbelow(True)

# Customize colors
for patch, color in zip(bplot1["boxes"], box_colors):
    patch.set_facecolor(color)

# Set background colors
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 0.5), 1.1, 1.5, facecolor=background_colors[0], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 1.5), 1.1, 1.5, facecolor=background_colors[1], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 2.5), 1.1, 5.5, facecolor=background_colors[2], edgecolor="none", zorder=0
    )
)
ax1.add_patch(
    plt.Rectangle(
        (-0.05, 7.5), 1.1, 3, facecolor=background_colors[3], edgecolor="none", zorder=0
    )
)

# Subplot 2: Field B
bplot2 = ax2.boxplot(
    performance[10:], vert=False, medianprops=medianprops, patch_artist=True
)
ax2.set_ylim(ylimits[1])
ax2.set_yticks(yticks[1])
ax2.set_yticklabels(methods)
ax2.set_xlim(xlimits[1])
ax2.set_xlabel(xlabel2)
ax2.set_facecolor("#f7f7f7")
ax2.xaxis.grid(True)
ax2.set_axisbelow(True)

for patch, color in zip(bplot2["boxes"], box_colors):
    patch.set_facecolor(color)

# Set background colors
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 0.5), 1.1, 1.5, facecolor=background_colors[0], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 1.5), 1.1, 1.5, facecolor=background_colors[1], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 2.5), 1.1, 5.5, facecolor=background_colors[2], edgecolor="none", zorder=0
    )
)
ax2.add_patch(
    plt.Rectangle(
        (-0.05, 7.5), 1.1, 3, facecolor=background_colors[3], edgecolor="none", zorder=0
    )
)

# Titles and Layout
fig.suptitle(title, fontsize=14)
plt.tight_layout()
plt.subplots_adjust(top=0.9)

# ===================
# Part 4: Saving Output
# ===================
# Save the figure
plt.savefig("box_79.pdf", bbox_inches="tight")
