
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate new data for populations of three cities over three periods
city1 = np.random.normal(2.5, 0.5, 20)
city2 = np.random.normal(3.0, 0.75, 20)
city3 = np.random.normal(1.5, 0.4, 20)

data = [city1, city2, city3]
ylabel = "Population (in millions)"
xticklabels = ["2000-2005", "2006-2010", "2011-2015"]
xticks = [1, 2, 3]
ylim = [0, 5]
categories = ["City A", "City B", "City C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size
plt.figure(figsize=(12, 6))
# Define colors for each boxplot
colors = ["#76c7c0", "#ffb3b3", "#c3c3e5"]

# Create subplots for each category
for i, category in enumerate(categories, 1):
    plt.subplot(1, 3, i)
    bplot = plt.boxplot(
        data,
        patch_artist=True,
        widths=0.7,
        medianprops=dict(color="black"),
        whiskerprops=dict(color="black"),
        capprops=dict(color="black"),
    )

    # Set colors for each box
    for patch, color in zip(bplot["boxes"], colors):
        patch.set_facecolor(color)

    # Scatter plot for data points
    for j in range(1, 4):
        y = data[j - 1]
        x = np.random.normal(j, 0.04, size=len(y))
        plt.plot(x, y, "k.", alpha=0.7)

    plt.title(category)
    plt.xticks(xticks, xticklabels)
    plt.ylim(ylim)
    if i == 1:
        plt.ylabel(ylabel)
    plt.gca().xaxis.grid(True)
    plt.gca().spines["top"].set_visible(False)
    plt.gca().spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap
plt.tight_layout()
plt.savefig("box_81.pdf", bbox_inches="tight")
