
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the boxplots in the transportation domain
data = {
    "Fuel Efficiency (MPG)": np.random.normal(25, 5, 100),
    "Travel Time (min)": np.random.normal(45, 10, 100),
    "Passengers (count)": np.random.poisson(20, 100),
    "Maintenance Costs ($)": np.random.exponential(30, 50),
}

# Reverse the order of data for boxplots
data_values = list(data.values())[::-1]
data_keys = list(data.keys())[::-1]

xlabel = "Values"
xlim = [0, 100]
xticks = np.arange(0, 101, 20)
title = "Transportation Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(10, 6))

# Create the boxplots with specific colors
boxprops = dict(linestyle="-", linewidth=2, color="black")
flierprops = dict(marker="D", color="grey", markersize=5)
medianprops = dict(linestyle="-", linewidth=2, color="black")

bp = ax.boxplot(
    data_values,
    vert=False,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
)

# Color palette: muted and professional
colors = ["#a6cee3", "#1f78b4", "#b2df8a", "#33a02c"][::-1]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Set the y-axis labels with reversed order
ax.set_yticklabels(data_keys)

# Set the x-axis label
ax.set_xlabel(xlabel)

# Adjust the x-axis limits and ticks
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.set_xticklabels(["{}%".format(i) for i in xticks])

# Set the title of the plot
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_86.pdf", bbox_inches="tight")
