
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the boxplots - Tourist Satisfaction Ratings (out of 100)
data = {
    "Guided Tours": np.random.uniform(60, 95, 100),
    "Self-Guided Tours": np.random.uniform(70, 90, 100),
    "Cruise Tours": np.random.uniform(50, 85, 100),
    "Adventure Tours": np.random.uniform(40, 80, 100),
}

# Reverse the order of data for boxplots
data_values = list(data.values())[::-1]
data_keys = list(data.keys())[::-1]

xlabel = "Tourist Satisfaction Ratings (%)"
xlim = [0, 100]
xticks = np.arange(0, 101, 20)
title = "Tourism Methods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis with the specified size
fig, ax = plt.subplots(figsize=(9, 5))

# Create the boxplots with specific colors
boxprops = dict(linestyle="-", linewidth=2, color="black")
flierprops = dict(marker="o", color="black", markersize=5)
medianprops = dict(linestyle="-", linewidth=2, color="black")

bp = ax.boxplot(
    data_values,
    vert=False,
    patch_artist=True,
    boxprops=boxprops,
    flierprops=flierprops,
    medianprops=medianprops,
)

# Using a vibrant color scheme
colors = ["#66c2a5", "#fc8d62", "#8da0cb", "#e78ac3"][::-1]
for patch, color in zip(bp["boxes"], colors):
    patch.set_facecolor(color)

# Set the y-axis labels with reversed order
ax.set_yticklabels(data_keys)

# Set the x-axis label
ax.set_xlabel(xlabel)

# Set the x-axis limits and ticks
ax.set_xlim(xlim)
ax.set_xticks(xticks)
ax.set_xticklabels(["{}%".format(i) for i in xticks])

# Set the title of the plot
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_88.pdf", bbox_inches="tight")
