
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Technology Adoption Rates for different years
data = [
    np.random.normal(20, 5, 100),  # Year 2010
    np.random.normal(30, 7, 100),  # Year 2012
    np.random.normal(45, 6, 100),  # Year 2015
    np.random.normal(60, 8, 100),  # Year 2018
    np.random.normal(75, 5, 100),  # Year 2020
]

labels = ["2010", "2012", "2015", "2018", "2020"]

# Axes Limits and Labels
ylim_values = [0, 100]
xlabel_value = "Year"
ylabel_value = "Adoption Rate (%)"
title_value = "Technology Adoption Rates Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the boxplot
fig, ax = plt.subplots(
    figsize=(8, 6)
)  # Adjusting figure size for better aspect ratio
bp = ax.boxplot(
    data,
    labels=labels,
    patch_artist=True,
    boxprops=dict(facecolor="#1f77b4", color="#1f77b4"),
    medianprops=dict(color="#ff7f0e", linewidth=2),
    whiskerprops=dict(color="#2ca02c", linestyle="--", linewidth=1.5),
    capprops=dict(color="#d62728", linewidth=1.5),
    showfliers=False 
)

# Customize colors
for patch in bp['boxes']:
    patch.set(facecolor='#17becf')  # Different shade for boxes

ax.set_ylim(ylim_values)
# Set labels
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)  # Set title

# Set grid
ax.grid(True, linestyle='--', color='gray', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("box_90.pdf", bbox_inches="tight")
