
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from scipy.stats import multivariate_normal
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data generation (Customer segments)
x = np.linspace(-100, 100, 400)
y = np.linspace(-100, 100, 400)
X, Y = np.meshgrid(x, y)
pos = np.dstack((X, Y))
rv1 = multivariate_normal([60, 10], [[900, 0], [0, 900]])  # High-spending
rv2 = multivariate_normal([-60, -10], [[1200, 0], [0, 1200]])  # Low-spending
Z1 = rv1.pdf(pos)
Z2 = rv2.pdf(pos)

# Text label parameters
title = "Customer Segmentation: Spending Habits"
xlabel = "Spending Amount (in $)"
ylabel = "Number of Transactions"
labels = ["High-Spending Customers", "Low-Spending Customers"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))
contour1 = plt.contourf(X, Y, Z1, cmap="Greens", alpha=0.7)
contour2 = plt.contourf(X, Y, Z2, cmap="Oranges", alpha=0.7)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Create legend with color patches
legend_patches = [
    Patch(color="green", label=labels[0]),
    Patch(color="orange", label=labels[1]),
]
plt.legend(handles=legend_patches, loc='upper right')

# Adjust plot to match the original image's dimensions
plt.gca().set_aspect("equal", adjustable="box")

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_21.pdf", bbox_inches="tight")
