
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt
from scipy.stats import multivariate_normal
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data generation (representing economic indicators)
x = np.linspace(-80, 80, 400)
y = np.linspace(-80, 80, 400)
X, Y = np.meshgrid(x, y)
pos = np.dstack((X, Y))
rv1 = multivariate_normal([20, 20], [[200, 0], [0, 200]])
rv2 = multivariate_normal([-20, -20], [[200, 0], [0, 200]])
Z1 = rv1.pdf(pos)
Z2 = rv2.pdf(pos)

# Text label parameters
title = "Economic Indicators Distribution"
xlabel = "GDP Growth Rate (%)"
ylabel = "Unemployment Rate (%)"
legend_labels = ["GDP Growth", "Unemployment"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))
contour1 = plt.contourf(X, Y, Z1, cmap="Greens", alpha=0.7)
contour2 = plt.contourf(X, Y, Z2, cmap="Oranges", alpha=0.7)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Create legend with color patches
legend_patches = [
    Patch(color="green", label=legend_labels[0]),
    Patch(color="orange", label=legend_labels[1]),
]
plt.legend(handles=legend_patches, loc='upper right')

# Adjust plot to match the original image's dimensions
plt.gca().set_aspect("equal", adjustable="box")

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_22.pdf", bbox_inches="tight")
