
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Setting seed for reproducibility
np.random.seed(42)

# Create a grid for Trait_1 and Trait_2
trait_1 = np.linspace(-3, 3, 100)
trait_2 = np.linspace(-3, 3, 100)
Trait_1, Trait_2 = np.meshgrid(trait_1, trait_2)

# Gaussian function to simulate psychological data distributions
def psychological_distribution(Trait_1, Trait_2):
    return (
        np.exp(-((Trait_1 - 0.5) ** 2 + (Trait_2 - 0.5) ** 2) / 0.5) +
        np.exp(-((Trait_1 + 1.5) ** 2 + (Trait_2 - 1.0) ** 2) / 0.3) +
        np.exp(-((Trait_1 - 1.0) ** 2 + (Trait_2 + 1.5) ** 2) / 0.7)
    )

# Calculate distribution values
values = psychological_distribution(Trait_1, Trait_2)
xlabel = "Trait 1"
ylabel = "Trait 2"
title = "Psychological Traits Interaction"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Custom discrete colormap
n_colors = 8
discrete_cmap = plt.cm.get_cmap("Pastel1", n_colors)

# Plotting the contour
contour = plt.contourf(Trait_1, Trait_2, values, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(values.min(), values.max(), n_colors))
cbar.set_label('Intensity')

# Label the axes
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=14)

# Enhance layout and save/ display
plt.grid(True, linestyle='--', color='grey', alpha=0.7)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("contour_25.pdf", bbox_inches="tight")
