
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data to create contour lines for climate studies
x = np.linspace(15, 45, 100)  # Temperature range in °C
y = np.linspace(30, 90, 100)  # Humidity range in %
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 25) ** 2 + (Y - 70) ** 2) / 100)  # Distribution centered at (25°C, 70%)
Z2 = np.exp(-((X - 35) ** 2 + (Y - 50) ** 2) / 100)  # Distribution centered at (35°C, 50%)
labels = ["Distribution A", "Distribution B"]
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
title = "Climate Data Contour Plot"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 8))

# Contour lines for Distribution A (dark orange) and Distribution B (dark blue)
CS1 = ax.contour(X, Y, Z1, colors="darkorange", linestyles='dashed', linewidths=1.5, label=labels[0])
CS2 = ax.contour(X, Y, Z2, colors="darkblue", linestyles='solid', linewidths=1.5, label=labels[1])

# Labels for x and y axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, loc='upper right')

# Set the aspect of the plot to be equal
ax.set_aspect('auto')
ax.grid()
ax.set_facecolor("#f4f4f4")
ax.set_ylim(30, 90)
ax.set_xlim(15, 45)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_28.pdf", bbox_inches="tight")
