
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample financial data for portfolios
x = np.linspace(0, 100, 100)  # Expected Return
y = np.linspace(0, 50, 100)   # Volatility
X, Y = np.meshgrid(x, y)
Z1 = np.exp(-((X - 50) ** 2 + (Y - 20) ** 2) / 200)
Z2 = np.exp(-((X - 60) ** 2 + (Y - 25) ** 2) / 200)
labels = ["Conservative Portfolio", "Aggressive Portfolio"]
xlabel = "Expected Return (%)"
ylabel = "Volatility (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(8, 8))

# Contour lines for Conservative (green) and Aggressive (purple) portfolios
CS1 = ax.contour(X, Y, Z1, colors="green", linestyles='dashed', linewidths=2, label=labels[0])
CS2 = ax.contour(X, Y, Z2, colors="purple", linestyles='solid', linewidths=2, label=labels[1])

# Labels for x and y axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels)

# Set the aspect of the plot
ax.set_aspect("auto")
ax.grid(True, linestyle='--', linewidth=0.7)
ax.set_facecolor("#f4f4f4")
ax.set_ylim(0, 50)
ax.set_xlim(0, 100)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_29.pdf", bbox_inches="tight")

