
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
X = np.linspace(-5, 5, 100)
Y = np.linspace(-5, 5, 100)
X, Y = np.meshgrid(X, Y)
Z = np.sin(X) * np.cos(Y)

# Text label parameters
xlabel = "X-axis"
ylabel = "Y-axis"
title = "Sine-Cosine Contour Plot"
suptitle = "Wave Pattern Visualized"
legendlabels = "Wave Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Filled contour with labels
fig, ax = plt.subplots(figsize=(8, 6))
cnt = ax.contour(X, Y, Z, colors="k", linewidths=0.75, linestyles='solid')
ax.clabel(cnt, cnt.levels, inline=True, fontsize=8)
cf = ax.contourf(X, Y, Z, cmap="viridis")  # A gradient colormap of blue to green

# Adding color bar to indicate intensity levels
cbar = fig.colorbar(cf, ax=ax)
cbar.set_label(legendlabels)

# Additional settings
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(suptitle, fontsize=12)
ax.grid(True, linestyle='--', alpha=0.6)  # Adding grid with dashed lines

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("contour_33.pdf", bbox_inches="tight")

