
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Labels and Titles
xlabel = "Longitude"
ylabel = "Latitude"
title = "Simulated Population Density"
colorbar_label = "Population Density"
suptitle = "Population Density Contour Map"
output_filename = "contour_5_6.pdf"

# Data
np.random.seed(0)
x = np.linspace(-5, 10, 100)
y = np.linspace(-5, 10, 100)
X, Y = np.meshgrid(x, y)

# Simulating population density with Gaussian functions
Z = (100 * np.exp(-((X - 2) ** 2 + (Y - 3) ** 2) / 7) +
     50 * np.exp(-((X - 7) ** 2 + (Y - 8) ** 2) / 5) +
     30 * np.exp(-((X - 1) ** 2 + (Y - 7) ** 2) / 6))

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 8))

# Filled contour with labels
cnt = ax.contour(X, Y, Z, colors="black", linestyles='dashed', linewidths=1)
ax.clabel(cnt, cnt.levels, inline=True, fontsize=10)
cf = ax.contourf(X, Y, Z, cmap="viridis")

# Enhance readability
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title, fontsize=14)
plt.suptitle(suptitle, fontsize=16)
cbar = fig.colorbar(cf)
cbar.set_label(colorbar_label)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("contour_35.pdf", bbox_inches="tight")
