
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate synthetic data for contour plots
x = np.linspace(-5, 5, 400)
y = np.linspace(-5, 5, 400)
X, Y = np.meshgrid(x, y)

# Define data surfaces for two healthcare teams
Z1 = np.exp(-3 * (X**2 + Y**2))  # Gaussian bump for Team X
Z2 = np.exp(-3 * ((X - 2) ** 2 + (Y + 2) ** 2))  # Gaussian bump for Team Y

# Plot configuration variables
title = "Contour Plot of Patient Outcomes"
labels = ["Team X", "Team Y"]
xlabel = "Treatment Metric"
ylabel = "Outcome Metric"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))
contour1 = plt.contour(X, Y, Z1, colors="#1f77b4", linestyles="-", linewidths=2)  # Blue for Team X
contour2 = plt.contour(X, Y, Z2, colors="#ff7f0e", linestyles="--", linewidths=2)  # Red for Team Y
plt.contourf(X, Y, Z1, alpha=0.3, cmap="Blues")
plt.contourf(X, Y, Z2, alpha=0.3, cmap="Reds")
plt.title(title)

# Adding labels and legend
legend_patches = [
    Patch(color="#1f77b4", label=labels[0], alpha=0.3),
    Patch(color="#ff7f0e", label=labels[1], alpha=0.3),
]
plt.legend(handles=legend_patches, loc="upper right")

# Customizing the plot appearance
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.grid(True, linestyle="--", alpha=0.6)
plt.axhline(0, color="black", linewidth=0.5)
plt.axvline(0, color="black", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_36.pdf", bbox_inches="tight")
