
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate synthetic data for contour plots
x = np.linspace(-5, 5, 400)
y = np.linspace(-5, 5, 400)
X, Y = np.meshgrid(x, y)

# Define two data surfaces for two regions
Z_urban = np.exp(-3 * (X**2 + Y**2))  # Gaussian bump for Urban region
Z_rural = np.exp(-3 * ((X - 1.5) ** 2 + (Y + 1.5) ** 2))  # Gaussian bump for Rural region

# Plot configuration variables
title = "Contour Plot of Employment Rate and Education Index"
labels = ["Urban Area", "Rural Area"]
xlabel = "Longitude"
ylabel = "Latitude"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))
contour_urban = plt.contour(X, Y, Z_urban, colors="blue", linestyles="-", linewidths=2)
contour_rural = plt.contour(X, Y, Z_rural, colors="orange", linestyles="--", linewidths=2)
plt.contourf(X, Y, Z_urban, alpha=0.3, cmap="Blues")
plt.contourf(X, Y, Z_rural, alpha=0.3, cmap="Oranges")
plt.title(title)

# Adding labels and legend
legend_patches = [
    Patch(color="blue", label=labels[0], alpha=0.3),
    Patch(color="orange", label=labels[1], alpha=0.3),
]
plt.legend(handles=legend_patches)

# Customizing the plot appearance
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.grid(True, linestyle="-.", alpha=0.6)
plt.axhline(0, color="black", linewidth=0.5)
plt.axvline(0, color="black", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_37.pdf", bbox_inches="tight")
