
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated data generation for religiosity and spirituality levels
religiosity = np.linspace(0, 100, 400)
spirituality = np.linspace(0, 100, 400)
REL, SPIR = np.meshgrid(religiosity, spirituality)
pos = np.dstack((REL, SPIR))

# Simulate Gaussian distributions for religiosity and spirituality
def gaussian(x, y, mean, cov):
    return np.exp(
        -((x - mean[0]) ** 2 / (2 * cov[0][0]) + (y - mean[1]) ** 2 / (2 * cov[1][1]))
    )

Z_religiosity = gaussian(REL, SPIR, [50, 50], [[200, 0], [0, 200]])
Z_spirituality = gaussian(REL, SPIR, [70, 30], [[150, 0], [0, 150]])

# Extracted variables
title = "Distribution of Religiosity and Spirituality Levels"
labels = ["Religiosity", "Spirituality"]
xlabel = "Religiosity Level"
ylabel = "Spirituality Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))

# Contour plots for the distributions
contour_religiosity = plt.contourf(REL, SPIR, Z_religiosity, cmap="Purples", alpha=0.6)
contour_spirituality = plt.contourf(REL, SPIR, Z_spirituality, cmap="Greens", alpha=0.6)
plt.title(title)

# Create legend with color patches
legend_patches = [
    Patch(color="purple", label=labels[0]),
    Patch(color="green", label=labels[1]),
]
plt.legend(handles=legend_patches)

# Axis labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adjust plot to be visually appealing
plt.gca().set_aspect("equal", adjustable="box")

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_41.pdf", bbox_inches="tight")
