
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.patches import Patch

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Sample data generation for historical events distribution
x = np.linspace(0, 100, 500)  # Simulate a timeline from 0 to 100 centuries
y = np.linspace(0, 100, 500)  # Simulate different regions from 0 to 100
X, Y = np.meshgrid(x, y)

# Define historical event density functions for different periods
def historical_density(x, y, x0, y0, sx, sy):
    return np.exp(-(((x - x0) ** 2) / (2 * sx**2) + ((y - y0) ** 2) / (2 * sy**2)))

# Generate data
Z1 = historical_density(X, Y, 20, 50, 15, 10)  # Ancient Period
Z2 = historical_density(X, Y, 50, 70, 10, 15)  # Medieval Period
Z3 = historical_density(X, Y, 80, 30, 12, 12)  # Modern Period

# Chart titles and labels
title = "Density of Historical Events"
xlabel = "Centuries"
ylabel = "Regions"
labels = ["Ancient Events", "Medieval Events", "Modern Events"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_fontsize = 12
title_fontsize = 16
label_fontsize = 14

# Plotting
plt.figure(figsize=(12, 8))
contour1 = plt.contourf(X, Y, Z1, cmap="Greens", alpha=0.6)
contour2 = plt.contourf(X, Y, Z2, cmap="Oranges", alpha=0.4)
contour3 = plt.contourf(X, Y, Z3, cmap="Purples", alpha=0.3)

# Title and labels
plt.title(title, fontsize=title_fontsize)
plt.xlabel(xlabel, fontsize=label_fontsize)
plt.ylabel(ylabel, fontsize=label_fontsize)

# Create legend with color patches
legend_patches = [
    Patch(color="green", label=labels[0]),
    Patch(color="orange", label=labels[1]),
    Patch(color="purple", label=labels[2]),
]
plt.legend(handles=legend_patches, fontsize=legend_fontsize)

# Additional plot adjustments
plt.gca().set_aspect("equal", adjustable="box")
plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Reduce whitespace around the plot
plt.tight_layout()
plt.savefig("contour_45.pdf", bbox_inches="tight")
