
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Create a grid of x and y values
x = np.linspace(-1.5, 1.5, 300)
y = np.linspace(-1.5, 1.5, 300)
X, Y = np.meshgrid(x, y)

# Adjust the lambda function to reflect a complex temperature distribution
def temperature_distribution_function(X, Y):
    return (
        np.exp(-((X - 0.5) ** 2 + (Y - 0.5) ** 2) / 0.02) * 0.6
        + np.exp(-((X + 0.5) ** 2 + (Y - 0.5) ** 2) / 0.04) * 0.7
        + np.exp(-((X - 0.5) ** 2 + (Y + 0.5) ** 2) / 0.03) * 0.8
        + np.exp(-((X + 0.5) ** 2 + (Y + 0.5) ** 2) / 0.05) * 0.5
    )

# Calculate the function values on the grid
Z = temperature_distribution_function(X, Y)
xlabel = "X Coordinate"
ylabel = "Y Coordinate"
title = "Complex Temperature Distribution"
colorbar_label = "Temperature Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(12, 10))

# Using a colormap that suits temperature visualization
n_colors = 20  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("inferno", n_colors)

contour = plt.contourf(X, Y, Z, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(Z.min(), Z.max(), n_colors))
cbar.set_label(colorbar_label, fontsize=14)

# Label the axes
plt.xlabel(xlabel, fontsize=16)
plt.ylabel(ylabel, fontsize=16)
plt.title(title, fontsize=18)

# Style adjustments
plt.grid(True, linestyle="--", alpha=0.7)  # Add a grid for better readability
plt.xticks(fontsize=14)
plt.yticks(fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_48.pdf", bbox_inches="tight")
