
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a grid of x and y values representing students and their test scores in two subjects
students = np.linspace(0, 100, 200)
scores = np.linspace(0, 100, 200)
X, Y = np.meshgrid(students, scores)

# Define a function to simulate test score distributions
def score_distribution_function(X, Y):
    # Simulate scores in Mathematics and Science
    math_scores = np.exp(-((X - 50) ** 2 + (Y - 70) ** 2) / 200) * 100  # Centered around (50, 70)
    science_scores = np.exp(-((X - 70) ** 2 + (Y - 50) ** 2) / 300) * 100  # Centered around (70, 50)
    return math_scores + science_scores

# Calculate the function values on the grid
Z = score_distribution_function(X, Y)
xlabel = "Student ID"
ylabel = "Score"
title = "Distribution of Student Test Scores in Mathematics and Science"
colorbar_label = "Score Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Use a colormap that suits educational data visualization
n_colors = 10  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("viridis", n_colors)  # Changed to viridis for better visualization

contour = plt.contourf(X, Y, Z, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(contour, ticks=np.linspace(Z.min(), Z.max(), n_colors))
cbar.set_label(colorbar_label)

# Label the axes
plt.xlabel(xlabel, fontsize=14)
plt.ylabel(ylabel, fontsize=14)
plt.title(title, fontsize=16)

# Style adjustments
plt.grid(True, linestyle="--", alpha=0.7)  # Add a grid for better readability
plt.xticks(fontsize=12)
plt.yticks(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_50.pdf", bbox_inches="tight")

# Show the final render to check visually
