
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Create a grid of x (dosage) and z (BP) values
np.random.seed(1)  # Different seed for different data
x = np.linspace(0, 100, 120)  # Dosage in mg
z = np.linspace(60, 180, 120)  # BP in mmHg
X, Z = np.meshgrid(x, z)

# Define the health landscape function with different peaks
def health_landscape(X, Z):
    return (
        np.exp(-((X - 20) ** 2 + (Z - 120) ** 2) / 200)
        + np.exp(-((X - 50) ** 2 + (Z - 140) ** 2) / 400)
        + np.exp(-((X - 80) ** 2 + (Z - 100) ** 2) / 600)
    )

# Calculate the function values on the grid
Z_values = health_landscape(X, Z)
xlabel = "Dosage (mg)"
ylabel = "Blood Pressure (mmHg)"
title = "Health Performance Landscape: Dosage vs. Blood Pressure"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a different colormap with "RdYlBu"
n_colors = 12  # Number of discrete colors in the colormap
discrete_cmap = plt.cm.get_cmap("RdYlBu", n_colors)

contour = plt.contourf(X, Z, Z_values, levels=n_colors, cmap=discrete_cmap)

# Add a color bar
cbar = plt.colorbar(
    contour, ticks=np.linspace(Z_values.min(), Z_values.max(), n_colors)
)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_51.pdf", bbox_inches="tight")
