
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a new set of grid for different variables
x = np.linspace(0, 252, 100)  # Trading days in a year
y = np.linspace(50, 150, 100)  # Stock price range
X, Y = np.meshgrid(x, y)

# Define a function to simulate volatility patterns in stock prices
def volatility_pattern(X, Y):
    return 0.2 * np.sin(2 * np.pi * X / 252) + 0.3 * np.sin(2 * np.pi * Y / 100) + 0.1 * np.cos(np.pi * X / 252) * np.sin(np.pi * Y / 100)

# Calculate values on the grid
Z_values = volatility_pattern(X, Y)
xlabel = "Time (Days)"
ylabel = "Stock Price ($)"
title = "Simulated Volatility Over Time"
cbar_label = "Volatility"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a distinct colormap with a finance theme (greens, and blues)
n_levels = 20  # Number of contour levels
cmap = plt.cm.viridis

contour = plt.contourf(X, Y, Z_values, levels=n_levels, cmap=cmap)
plt.contour(X, Y, Z_values, levels=n_levels, colors="k", linewidths=0.5)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_54.pdf", bbox_inches="tight")
