
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a grid of x and y values representing different regions of a farm
x = np.linspace(0, 100, 100)
y = np.linspace(0, 100, 100)
X, Y = np.meshgrid(x, y)

# Function representing the soil moisture distribution influenced by rainfall and irrigation patterns
def soil_moisture_distribution(X, Y):
    return np.sin(X / 10) * np.cos(Y / 10) + 0.5 * np.sin(Y / 10) - 0.3 * np.cos(X / 10)

# Calculate the function values on the grid
Z_values = soil_moisture_distribution(X, Y)
xlabel = "Distance (meters)"
ylabel = "Distance (meters)"
title = "Soil Moisture Distribution"
cbar_label = "Moisture Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a colormap suitable for soil moisture data
cmap = plt.cm.get_cmap("YlGnBu")

contour = plt.contourf(X, Y, Z_values, levels=20, cmap=cmap)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.ylabel(ylabel, fontsize=12, fontweight='bold')
plt.title(title, fontsize=14, fontweight='bold')

# Enhance grid lines for better readability
plt.grid(True, linestyle="--", alpha=0.5, color='grey')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_57.pdf", bbox_inches="tight")
