
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Create a grid of latitude and longitude values representing temperature distribution
latitude = np.linspace(-90, 90, 100)
longitude = np.linspace(-180, 180, 100)
Latitude, Longitude = np.meshgrid(latitude, longitude)

# Function representing temperature distribution influenced by geographical factors
def temperature_distribution(Latitude, Longitude):
    # Simulating a simplistic temperature distribution model
    return 30 - ((Latitude / 90)**2 * 30) + 10 * np.sin(3 * np.pi * Longitude / 180)

# Calculate the function values on the grid
Temperature = temperature_distribution(Latitude, Longitude)
xlabel = "Longitude (degrees)"
ylabel = "Latitude (degrees)"
title = "Geographical Temperature Distribution"
cbar_label = "Temperature (°C)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the contour plot
plt.figure(figsize=(10, 8))

# Using a colormap suitable for temperature data
cmap = plt.cm.get_cmap("Spectral")

contour = plt.contourf(Longitude, Latitude, Temperature, levels=25, cmap=cmap)

# Add a color bar
cbar = plt.colorbar(contour)
cbar.set_label(cbar_label)

# Label the axes
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Enhance grid lines for better readability
plt.grid(True, linestyle="--", alpha=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()

# Show the plot
plt.savefig("contour_58.pdf", bbox_inches="tight")
