
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(2)
# Hypothetical vehicle speed data over different times of the day and days of the week
hours = np.linspace(0, 24, 100)  # hours of the day
days = np.linspace(1, 7, 100)  # days of the week
Hours, Days = np.meshgrid(hours, days)
Speed1 = 30 + 10 * np.exp(-((Hours - 8) ** 2 + (Days - 3) ** 2) / 15)  # steady traffic
Speed2 = 40 + 15 * np.exp(-((Hours - 17) ** 2 + (Days - 5) ** 2) / 15)  # varied traffic
labels = ["Steady Traffic", "Varied Traffic"]
xlabel = "Hours of the Day"
ylabel = "Days of the Week"
title = "Vehicle Speed Distribution Over a Week"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

# Contour lines for Steady Traffic (green) and Varied Traffic (red)
CS1 = ax.contour(
    Hours, Days, Speed1, colors="green", linestyles="solid", linewidths=1.5, label=labels[0]
)
CS2 = ax.contour(
    Hours, Days, Speed2, colors="darkorange", linestyles="dashed", linewidths=1.5, label=labels[1]
)

# Labels for x and y axes and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels)

# Set the aspect of the plot for better readability
ax.set_aspect("auto")
ax.grid(True, linestyle='--', linewidth=0.5)
ax.set_facecolor("#f3f3f3")
ax.set_ylim(1, 7)
ax.set_xlim(0, 24)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_61.pdf", bbox_inches="tight")
