
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate data for a communication domain
x = np.linspace(-15, 15, 150)
y = np.linspace(-15, 15, 150)
X, Y = np.meshgrid(x, y)

# Signal strength (Field A) and Noise levels (Field B)
Z1 = np.exp(-((X-5)**2 + (Y-5)**2)/20)  # Signal strength
Z2 = np.exp(-((X+5)**2 + (Y+5)**2)/20)  # Noise levels

labels = ["Signal Strength", "Noise Levels"]
xlabel = "Distance (km)"
ylabel = "Distance (km)"
title = "Communication Field Distribution"
cbar_label = "Intensity"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(12, 9))

# Contour lines for Signal Strength (cool colors) and Noise Levels (warm colors)
CS1 = ax.contour(X, Y, Z1, colors="blue", linestyles="solid", linewidths=1.5)
CS2 = ax.contour(X, Y, Z2, colors="orange", linestyles="dashed", linewidths=2)

# Labels for x and y axes
ax.set_xlabel(xlabel, fontsize=15)
ax.set_ylabel(ylabel, fontsize=15)
ax.set_title(title, fontsize=18)

# Adding a legend manually
h1, _ = CS1.legend_elements()
h2, _ = CS2.legend_elements()
ax.legend([h1[0], h2[0]], labels, fontsize=13)

# Set the aspect of the plot
ax.set_aspect("equal")
ax.grid(True)
ax.set_facecolor("#f5f5f5")
ax.set_ylim(-15, 15)
ax.set_xlim(-15, 15)

# Add color bar to represent field intensity
field_intensity = ax.contourf(X, Y, Z1 + Z2, alpha=0.3, cmap="coolwarm")
cbar = fig.colorbar(field_intensity, ax=ax)
cbar.set_label(cbar_label, fontsize=13)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("contour_64.pdf", bbox_inches="tight")
